/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.engine.test;

import com.quantumdata.sct.dao.impl.DeviceCapabilityDAO;
import com.quantumdata.sct.dao.impl.TestCapabilityDAO;
import com.quantumdata.sct.dao.impl.XMLDAOFactory;
import com.quantumdata.sct.dao.vo.DeviceCapabilityVO;
import com.quantumdata.sct.dao.vo.TestCapabilityVO;
import com.quantumdata.sct.dao.vo.TestVO;
import com.quantumdata.sct.engine.test.ITestFilter;
import com.quantumdata.sct.util.SCTSelection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

public class DeviceTypeTestFilter
implements ITestFilter {
    private ArrayList deviceCapabilityIDs;

    public DeviceTypeTestFilter() {
        try {
            String string = SCTSelection.instance().getDeviceID();
            this.deviceCapabilityIDs = new ArrayList();
            DeviceCapabilityDAO deviceCapabilityDAO = (DeviceCapabilityDAO)XMLDAOFactory.getDeviceCapabilityDAO();
            DeviceCapabilityVO deviceCapabilityVO = (DeviceCapabilityVO)deviceCapabilityDAO.read(string);
            for (DeviceCapabilityVO.DeviceCapabilityElementVO deviceCapabilityElementVO : deviceCapabilityVO.getDeviceCapabilityElements()) {
                this.deviceCapabilityIDs.add(deviceCapabilityElementVO.getCapabilityId());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Collection filter(Collection collection) throws Exception {
        if (collection == null) {
            throw new IllegalArgumentException("Test collection is null");
        }
        TestCapabilityDAO testCapabilityDAO = (TestCapabilityDAO)XMLDAOFactory.getTestCapabilityDAO();
        Vector<TestVO> vector = new Vector<TestVO>();
        for (TestVO testVO : collection) {
            TestCapabilityVO testCapabilityVO = (TestCapabilityVO)testCapabilityDAO.read(testVO.getId());
            String string = testCapabilityVO.getPrimaryCapabilityId();
            if (!this.deviceCapabilityIDs.contains(string)) continue;
            vector.add(testVO);
        }
        return vector;
    }
}

